#!/bin/bash

# Constants
SOURCE_FOLDER="/var/logs/afe/can-dumps"  # Change this to your folder name

# Parse command line arguments
if [ $# -ge 1 ]; then
    SOURCE_FOLDER=$1
fi

# Check if folder exists
if [ ! -d "$SOURCE_FOLDER" ]; then
    echo "Error: Folder '$SOURCE_FOLDER' does not exist."
    exit 1
fi

# Find all .txt files in the folder
txt_files=$(find "$SOURCE_FOLDER" -type f -name "*.txt" -print)

# Check if any .txt files were found
if [ -z "$txt_files" ]; then
    echo "No .txt files found in '$SOURCE_FOLDER'."
    exit 0
fi

# Process each .txt file
for file in $txt_files; do
    # Get the directory and filename
    dir=$(dirname "$file")
    filename=$(basename "$file")
    
    # Create compressed filename
    compressed_file="${dir}/${filename}.gz"
    
    # Compress the file
    if gzip -c "$file" > "$compressed_file"; then
        # Remove the original file if compression was successful
        if rm "$file"; then
            echo "Successfully compressed and removed: $filename"
        else
            echo "Warning: Failed to remove original file: $file"
        fi
    else
        echo "Error: Failed to compress file: $file"
    fi
done

echo "Compression process completed."