#!/bin/bash

# Absolute path to this script, e.g. /home/user/bin/foo.sh
SCRIPT=$(readlink -f "$0")
# Absolute path this script is in, thus /home/user/bin
BASE_DIR=$(dirname "$SCRIPT")
ARCHIVE_NAME=update.tar.gz

echo "Removing old files..."
systemctl disable afe.service
rm -rf /opt/afe
echo "... old files have been removed"

echo "Creating afe directory ..."
mkdir -p /opt/afe
chmod 755 /opt/afe
echo "... created"
    
echo "Starting rsync"
cd "${BASE_DIR}"
rsync -av --exclude "${ARCHIVE_NAME}" --exclude "install.sh" ./afe/ /opt/afe/
cd "${BASE_DIR}"

echo "Apllying file attributes and permissions for executables"

chmod a+x /opt/afe/bin/startup.sh
chmod a+x /opt/afe/bin/manager
chmod -R a+x /opt/afe/bin/extensions

# Misc utils
find "/opt/afe/bin/misc" -type f -exec chmod a+x {} \;

echo "Applying neccesary permissions for services..."
chmod 644 /opt/afe/bin/afe.service
echo "Reloading systemctl demons..."
systemctl daemon-reload
echo "Registering services..."
systemctl enable /opt/afe/bin/afe.service
