#!/bin/bash

# Absolute path to this script, e.g. /home/user/bin/foo.sh
SCRIPT=$(readlink -f "$0")
# Absolute path this script is in, thus /home/user/bin
BASE_DIR=$(dirname "$SCRIPT")

CAN_DUMPS_DIR=/var/logs/afe/can-dumps
mkdir -p ${CAN_DUMPS_DIR}
CAN_DUMP_FILENAME="$(date +%Y-%m-%d_%H-%M-%S).txt"
LOG_FILES_COUNT=$(find $CAN_DUMPS_DIR -maxdepth 1 -type f | wc -l)
LOG_FILES_EXPECTED_COUNT="100"
# Compare and output result
if [ "$LOG_FILES_COUNT" -le "$LOG_FILES_EXPECTED_COUNT" ]; then
    timeout 600 /bin/bash ${BASE_DIR}/can-dump.sh can0 "${CAN_DUMPS_DIR}/${CAN_DUMP_FILENAME}"
#    timeout 10 ping 8.8.8.8 > "${CAN_DUMPS_DIR}/${CAN_DUMP_FILENAME}"
else 
    echo "Max log files count reached: $LOG_FILES_COUNT"
fi

/bin/bash ${BASE_DIR}/compress-log-files.sh ${CAN_DUMPS_DIR}